# encoding: UTF-8

import gevent.pool

from appcore.injection import register_injection
from dns_hosting.services.dnsmaster.dnsserver import DNSMasterDNSServer
from dns_hosting.services.dnsmaster.httpserver import DNSMasterHttpServer
from dns_hosting.services.dnsmaster.properties import DNSMasterProperties


def configure_dnsmaster(app, environment):
    if 'dnsmaster-dns' in environment.profiles:
        dns_properties = DNSMasterProperties(environment, 'dnsmaster.dns')
        dns_server = DNSMasterDNSServer(
            listener=dns_properties.listener,
            app=app,
            backlog=dns_properties.backlog,
            spawn=dns_properties.workers,
        )
        register_injection(app, 'dnsmaster_dns_server', dns_server)

    if 'dnsmaster-http' in environment.profiles:
        http_properties = DNSMasterProperties(environment, 'dnsmaster.http')
        http_server = DNSMasterHttpServer(
            listener=http_properties.listener,
            app=app,
            backlog=http_properties.backlog,
            spawn=http_properties.workers,
        )
        register_injection(app, 'dnsmaster_http_server', http_server)
