# encoding: UTF-8

import sqlalchemy as sa
import sqlalchemy.ext.declarative.api as decl

from appcore.injection import register_injection
from dns_hosting.models.domains import ChangeLog
from dns_hosting.models.domains import Domain
from dns_hosting.models.domains import Record

MODELS = [
    Domain,
    Record,
    ChangeLog,
]


def configure_models(app, _):
    metadata = sa.MetaData()
    registry = {}

    for model in MODELS:
        try:
            # noinspection PyUnresolvedReferences
            metadata = model.metadata
        except AttributeError:
            decl.instrument_declarative(model, registry, metadata)

    models = type('ModelsRegistry', (object,), registry)

    register_injection(app, 'metadata', metadata)
    register_injection(app, 'models', models)
