# encoding: UTF-8


from ws_properties.environ.mapper import ObjectMapper
from ws_properties.environ.mapper import ValueMapper

from appcore.unistat.agent import DEFAULT_MAX_SIZE
from appcore.unistat.agent import DEFAULT_METASYNC
from appcore.unistat.agent import DEFAULT_PATH
from appcore.unistat.agent import DEFAULT_SYNC
from appcore.unistat.agent import unistat_agent

UNISTAT_PROPERTIES = ObjectMapper(
    path=ValueMapper(str, default=DEFAULT_PATH),
    max_size=ValueMapper(int, default=DEFAULT_MAX_SIZE),
    metasync=ValueMapper(bool, default=DEFAULT_METASYNC),
    sync=ValueMapper(bool, default=DEFAULT_SYNC),
)


def configure_unistat(app, environment):
    unistat_properties = UNISTAT_PROPERTIES.map(environment, 'unistat')
    unistat_agent.setup(**unistat_properties)
