# encoding: UTF-8

from appcore.web.plugin import JsonWebErrorsPlugin
from appcore.web.request_id import RequestIDPlugin
from dns_hosting.views.domains import domains_bp
from dns_hosting.views.events import events_bp
from dns_hosting.views.health import health_bp


def configure_web(app, environment):
    if 'web' not in environment.profiles:
        return

    JsonWebErrorsPlugin(app)
    RequestIDPlugin(app)

    app.url_map.redirect_defaults = False
    app.url_map.strict_slashes = False

    app.register_blueprint(health_bp)
    app.register_blueprint(domains_bp, url_prefix='/public/domains/')
    app.register_blueprint(domains_bp, url_prefix='/api/v1/domains/')
    app.register_blueprint(events_bp, url_prefix='/public/events/')
    app.register_blueprint(events_bp, url_prefix='/api/v1/events/')
