# encoding: UTF-8

import requests
import tvm2

from appcore.security.exceptions import SecurityError
from dns_hosting.services.auth.model import HEADER_YA_SERVICE_TICKET


class Tvm2RequestsAuthenticator(object):
    def __init__(self, tvm2_client, client_id):
        self.tvm2_client = tvm2_client  # type: tvm2.TVM2
        self.client_id = client_id

    def _get_ticket(self):
        tickets = self.tvm2_client.get_service_tickets(self.client_id)
        ticket = tickets.get(self.client_id)

        if ticket is None:
            msg = 'Can not obtain service ticket for destination %s'
            raise SecurityError(msg % self.client_id)

        return ticket

    def __call__(self, request):
        # type: (requests.PreparedRequest) -> requests.PreparedRequest

        request.headers[HEADER_YA_SERVICE_TICKET] = self._get_ticket()
        return request
