# encoding: UTF-8

import enum

HEADER_YA_SERVICE_TICKET = 'X-Ya-Service-Ticket'
HEADER_YA_USER_TICKET = 'X-Ya-User-Ticket'
HEADER_UID = 'X-UID'


class Scope(str, enum.Enum):
    manage_domains = 'directory_dns:manage_domains'
    manage_technical = 'directory_dns:manage_technical'
    fire_events = 'directory_dns:fire_events'
    authorize_user_by_xuid = 'directory_dns:authorize_user_by_xuid'
    manage_any_domain = 'directory_dns:manage_any_domain'

    @classmethod
    def extract_any(cls, values):
        """
        Находит и возвращает скоупы среди списка строковых идентификаторов.

        :param values: Список строковых идентификаторов
        :return: Множество скоупов, найденых в списке
        """

        resolved = set()

        for value in values:
            try:
                resolved.add(cls(value))
            except ValueError:
                pass

        return resolved
