# encoding: UTF-8

from appcore.security.model import AuthIdentity
from appcore.security.provider import AuthProvider
from dns_hosting.services.auth.model import Scope


class DebugAuthProvider(AuthProvider):
    def __init__(self, without_scopes=None):
        self.scopes = set(Scope.__members__.values())
        if without_scopes:
            if not isinstance(without_scopes, set):
                raise RuntimeError('without_scopes in DebugAuthProvider must be set')
            self.scopes -= without_scopes

    def authenticate_request(self, request, remote_identity):
        uid = None
        if 'X-UID' in request.headers:
            uid = request.headers['X-UID']

        return AuthIdentity(
            client_id='debug',
            client_scopes=self.scopes,
            user_id=uid,
        )
