# encoding: UTF-8

from appcore.security.exceptions import UnauthenticatedAccessError
from appcore.security.model import HEADER_REAL_IP
from appcore.security.model import HEADER_USER_IP


class NoRealIpError(UnauthenticatedAccessError):
    def __init__(self):
        super(NoRealIpError, self).__init__(
            'No \'%s\' header provided' % HEADER_REAL_IP
        )


class NoUserIpError(UnauthenticatedAccessError):
    def __init__(self):
        super(NoUserIpError, self).__init__(
            'No \'%s\' header provided' % HEADER_USER_IP
        )


class InvalidOAuthTokenError(UnauthenticatedAccessError):
    def __init__(self):
        super(InvalidOAuthTokenError, self).__init__(
            'Invalid OAuth token provided'
        )


class ExpiredOAuthTokenError(UnauthenticatedAccessError):
    def __init__(self):
        super(ExpiredOAuthTokenError, self).__init__(
            'OAuth token is invalid or had expired'
        )

    def _get_headers(self):
        return {
            'WWW-Authenticate': 'OAuth '
                                'realm=\'Service\', '
                                'error=\'expired_token\''
        }


class InvalidServiceTicketError(UnauthenticatedAccessError):
    def __init__(self):
        super(InvalidServiceTicketError, self).__init__(
            'Invalid service ticket',
        )


class InvalidUserTicketError(UnauthenticatedAccessError):
    def __init__(self):
        super(InvalidUserTicketError, self).__init__(
            'Invalid user ticket',
        )


class InvalidUIDSpecifiedError(UnauthenticatedAccessError):
    def __init__(self):
        super(InvalidUIDSpecifiedError, self).__init__(
            'Invalid UID specified'
        )
