# encoding: UTF-8

from appcore.security.provider import AuthProvider


class HostSpecificAuthProvider(AuthProvider):
    def __init__(self, provider, rules):
        self.provider = provider
        self.rules = rules

    def _is_host_allowed(self, domain):
        for rule in self.rules:
            if isinstance(rule, (str, unicode)):
                if domain == rule:
                    return True
            elif rule(domain):
                return True

        return False

    def authenticate_request(self, request, remote_identity):
        host = request.headers['Host']
        if not self._is_host_allowed(host):
            return
        else:
            return self.provider.authenticate_request(request, remote_identity)
