# encoding: UTF-8

import json

import gevent.pywsgi
from ws_properties.utils.logs import get_logger_for_instance

from appcore.injection import Injected
from appcore.tx.plugin import tx_manager
from dns_hosting.dao.domains import DomainRepository


class DNSMasterHttpServer(gevent.pywsgi.WSGIServer):
    domains = Injected('domain_repository')  # type: DomainRepository

    def __init__(self, listener, app, backlog=None, spawn='default',
                 **ssl_args):
        self._logger = get_logger_for_instance(self)
        super(DNSMasterHttpServer, self).__init__(
            listener=listener,
            backlog=backlog,
            spawn=spawn,
            log=self._logger,
            error_log=self._logger,
            **ssl_args
        )
        self.app = app
        self._encoder = json.JSONEncoder()

    def application(self, environ, start_response):
        with self.app.app_context(), tx_manager:
            start_response(
                '200 OK',
                [
                    ('Content-Type', 'application/json'),
                ],
            )
            names_it = self.domains.get_domain_names()
            adapted_names_it = IteratorJSONAdapter(names_it)
            for chunk in self._encoder.iterencode(adapted_names_it):
                yield chunk


class IteratorJSONAdapter(list):
    def __init__(self, iter):
        super(IteratorJSONAdapter, self).__init__()
        self.__iter = iter

    def __len__(self):
        return 1

    def __iter__(self):
        return self

    def next(self):
        return next(self.__iter)
