# encoding: UTF-8

from ws_properties.environ.mapper import ObjectMapper, ValueMapper


class DNSMasterProperties(object):
    _MAPPER = ObjectMapper(
        host=ValueMapper(str),
        port=ValueMapper(int),
        backlog=ValueMapper(int),
        workers=ValueMapper(int),
    )

    def __init__(self, environment, path):
        data = self._MAPPER.map(environment, path)

        self.host = data['host']
        self.port = data['port']
        self.backlog = data['backlog']
        self.workers = data['workers']

    @property
    def listener(self):
        return self.host, self.port
