# encoding: UTF-8

import os

from ws_properties.environ.mapper import ObjectMapper, ValueMapper, ListMapper


class NsdServerProperties(object):
    _MAPPER = ObjectMapper(
        listen=ListMapper(str),
        config_file=ValueMapper(str),
        storage_dir=ValueMapper(str),
        runtime_dir=ValueMapper(str),
        executable=ValueMapper(str),
        workers=ValueMapper(int),
        username=ValueMapper(str),
        graceful_shutdown_timeout=ValueMapper(float),
        dnsmaster=ObjectMapper(
            dns=ObjectMapper(
                host=ValueMapper(str),
                port=ValueMapper(int),
            ),
            http=ObjectMapper(
                host=ValueMapper(str),
                port=ValueMapper(int),
                sync_interval=ValueMapper(float),
            )
        ),
        control=ObjectMapper(
            host=ValueMapper(str),
            port=ValueMapper(int),
            keyfile=ValueMapper(str),
            certfile=ValueMapper(str),
        ),
        stat=ObjectMapper(
            host=ValueMapper(str),
            port=ValueMapper(int),
            interval=ValueMapper(float),
            zonestatus_interval=ValueMapper(float),
        )
    )

    def __init__(self, environment, path):
        data = self._MAPPER.map(environment, path)

        self.listen = data['listen']
        self.config_file = data['config_file']
        self.storage_dir = data['storage_dir']
        self.zone_file = os.path.join(self.storage_dir, 'zone.list')
        self.runtime_dir = data['runtime_dir']
        self.executable = data['executable']
        self.workers = data['workers']
        self.username = data['username']
        self.graceful_shutdown_timeout = data['graceful_shutdown_timeout']

        self.dnsmaster = self._DNSMaster(data['dnsmaster'])
        self.control = self._Control(data['control'])
        self.stat = self._Stat(data['stat'])

    class _DNSMaster(object):
        def __init__(self, data):
            self.dns = self._DNS(data['dns'])
            self.http = self._Http(data['http'])

        class _DNS(object):
            def __init__(self, data):
                self.host = data['host']
                self.port = data['port']

            @property
            def address(self):
                return '%s@%d' % (self.host, self.port)

        class _Http(object):
            def __init__(self, data):
                self.host = data['host']
                self.port = data['port']
                self.sync_interval = data['sync_interval']

    class _Control(object):
        def __init__(self, data):
            self.host = data['host']
            self.port = data['port']
            self.keyfile = data['keyfile']
            self.certfile = data['certfile']

    class _Stat(object):
        def __init__(self, data):
            self.host = data['host']
            self.port = data['port']
            self.interval = data['interval']
            self.zonestatus_interval = data['zonestatus_interval']
