# encoding: UTF-

import Queue
import threading

import sqlalchemy.exc

from ws_properties.utils.logs import get_logger_for_instance


class ThreadedLoader(threading.Thread):
    def __init__(self, engine, stmt, batch_size, queue_size):
        super(ThreadedLoader, self).__init__()
        self.daemon = True
        self.__engine = engine
        self.__stmt = stmt
        self.__batch_size = batch_size
        self.__queue = Queue.Queue(queue_size)
        self.__logger = get_logger_for_instance(self)

    def __iter__(self):
        while True:
            batch = self.__queue.get()
            if isinstance(batch, Exception):
                raise batch
            else:
                for item in batch:
                    yield dict(item)

    def _try_run(self, last_id):
        try:
            try:
                result_proxy = self.__engine.execute(
                    sqlalchemy.text(self.__stmt),
                    starts_from=last_id,
                )
                batch = result_proxy.fetchmany(self.__batch_size)
                while batch:
                    last_id = batch[-1]['id']
                    self.__queue.put(batch)
                    batch = result_proxy.fetchmany(self.__batch_size)
            except sqlalchemy.exc.OperationalError as e:
                if 'SSL SYSCALL error: EOF detected' in e.message:
                    return last_id
                raise
        except Exception as e:
            self.__logger.exception('Failed to load record')
            self.__queue.put(e)
        finally:
            self.__queue.put(StopIteration())

    def run(self):
        last_id = 0
        while True:
            last_id = self._try_run(last_id)
            if last_id is None:
                break
