# encoding: UTF-8

import os


class QueryBundle(object):
    def __init__(self):
        self.__queries = {}

    def load(self, environment, queries):
        assets_root = environment.get_property('assets_root')
        for query in queries:
            path = os.path.join(assets_root, 'queries', query + '.sql')
            with open(path) as f:
                self.__queries[query] = f.read().decode('UTF-8')

    def get(self, name):
        try:
            return self.__queries[name]
        except KeyError:
            raise ValueError('Query not found')
