# encoding: UTF-8

import gevent
from ws_properties.utils.logs import get_logger_for_instance


class LoggedHub(gevent.hub.Hub):
    def __init__(self, loop=None, default=None):
        super(LoggedHub, self).__init__(loop, default)
        self._logger = get_logger_for_instance(self)

    def print_exception(self, context, type, value, tb):
        self._logger.error(
            'Error occurred in application loop.',
            exc_info=(type, value, tb),
        )


def set_hub_logging():
    gevent.hub.set_default_hub_class(LoggedHub)
