# encoding: UTF-8

import functools

import gevent


class StreamReader(object):
    def __init__(self, stream):
        self.__stream = stream

    def close(self):
        self.__stream.close()

    def read(self, read_cb, nbytes):
        gevent.spawn(
            self.__stream.read,
            nbytes,
        ).rawlink(
            functools.partial(
                self.__stream_read,
                read_cb,
                nbytes,
            )
        )

    def __stream_read(self, read_cb, nbytes, result):
        try:
            data = result.get()
        except Exception as e:
            read_cb(self, e, None, nbytes)
        else:
            read_cb(self, None, data, nbytes)

    def readline(self, read_cb):
        gevent.spawn(
            self.__stream.readline,
        ).rawlink(
            functools.partial(
                self.__stream_readline,
                read_cb,
            )
        )

    def __stream_readline(self, read_cb, result):
        try:
            data = result.get()
        except Exception as e:
            read_cb(self, e, None)
        else:
            read_cb(self, None, data)
