# encoding: UTF-8

import sys
import inspect
import logging
import numpy as np

from appcore.unistat.agent import unistat_agent
from appcore.unistat.stat import Stat


class Stats(object):
    ALL_STATS = []

    requests_time = Stat.hgram(
        'requests_time',
        bins=sorted(
            [0, sys.maxint] +
            [0.001 * (10 ** (i / 2.)) for i in xrange(10)]
        ),
    )

    requests_count = Stat.summ('requests_count')

    http_500_count = Stat.summ('http_x500_count')
    http_499_count = Stat.summ('http_x499_count')

    log_errors_count = Stat.summ('log_errors_count')


Stats.ALL_STATS = [
    value
    for _, value in inspect.getmembers(Stats)
    if isinstance(value, Stat)
]


# noinspection PyAbstractClass
class ErrorStatHandler(logging.Handler):
    def handle(self, record):
        if record.levelno >= logging.ERROR:
            unistat_agent.put(Stats.log_errors_count, 1)
