# encoding: UTF-8

import click
import flask


class ApplicationCommand(click.Command):
    def __init__(self, *args, **kwargs):
        callback = kwargs.pop('callback', None)
        if callback is None:
            if len(args) > 3:
                callback = args[2]
                args = args[:2] + args[3:]
            else:
                callback = self.callback

        super(ApplicationCommand, self).__init__(
            *args,
            callback=callback,
            **kwargs
        )

    def invoke(self, ctx):
        if not isinstance(ctx.obj, flask.Flask):
            raise ValueError(
                'Flask application must be provided as context object'
            )

        with ctx.obj.app_context():
            return super(ApplicationCommand, self).invoke(ctx)

    def callback(self):
        raise NotImplementedError
