# encoding: UTF-8

import errno
import os


def touch_file(path):
    with open(path, 'wb') as _:
        pass


def safe_makedir(path):
    try:
        os.makedirs(path)
    except OSError as e:
        if e.errno != errno.EEXIST or not os.path.isdir(path):
            raise


def safe_unlink(path):
    try:
        os.unlink(path)
    except OSError as e:
        if e.errno == errno.ENOENT:
            return False
        else:
            raise
    else:
        return True