# encoding: UTF-8


def safe_next(it):
    try:
        return next(it)
    except StopIteration:
        return None


def ijoin(it1, it2, cmp=cmp, default=None):
    it1, it2 = iter(it1), iter(it2)
    v1, v2 = safe_next(it1), safe_next(it2)

    while v1 is not None and v2 is not None:
        value = cmp(v1, v2)
        if value < 0:
            yield v1, default
            v1 = safe_next(it1)
        elif value > 0:
            yield default, v2
            v2 = safe_next(it2)
        else:
            yield v1, v2
            v1, v2 = safe_next(it1), safe_next(it2)

    while v1 is not None:
        yield v1, default
        v1 = safe_next(it1)

    while v2 is not None:
        yield default, v2
        v2 = safe_next(it2)
