# encoding: UTF-8

import random

import rfc3986
import sqlalchemy.engine.url as url
import sqlalchemy.util as util


def make_postgres10_url(name, datacenter=None):
    parsed = rfc3986.urlparse(name)
    components = filter(bool, parsed.userinfo.split(':', 1))
    components = map(url._rfc_1738_unquote, components)
    components += [None] * (2 - len(components))

    if parsed.query:
        query = {}

        for key, value in util.parse_qsl(parsed.query):
            if util.py2k:
                key = key.encode('ascii')
            if key in query:
                query[key] = util.to_list(query[key])
                query[key].append(value)
            else:
                query[key] = value
    else:
        query = None

    if parsed.host and datacenter:
        datacenter = datacenter.lower()
        hosts = parsed.host.split(',')

        for i in xrange(len(hosts)):
            if hosts[i].lower().startswith(datacenter):
                preferred_idx = i
                break
        else:
            preferred_idx = random.randrange(len(hosts))

        # Swap first host with preferred
        preferred_host = hosts[preferred_idx]
        hosts[preferred_idx] = hosts[0]
        hosts[0] = preferred_host

        parsed_host = ','.join(hosts)
    else:
        parsed_host = parsed.host

    return url.URL(
        drivername=parsed.scheme,
        username=components[0],
        password=components[1],
        host=parsed_host,
        port=parsed.port,
        database=parsed.path.lstrip('/'),
        query=query,
    )
