# encoding: UTF-8


def force_str(value, encoding='UTF-8'):
    if isinstance(value, str):
        return value
    else:
        return value.encode(encoding)


def force_unicode(value, encoding='UTF-8'):
    if isinstance(value, str):
        return value.decode(encoding)
    else:
        return value


def try_idna_decode(value):
    try:
        return force_str(value).decode('idna')
    except (UnicodeDecodeError, UnicodeError):
        return value