# encoding: UTF-8

import flask
import flask.views

from appcore.unistat.agent import unistat_agent
from dns_hosting.stats import Stats

health_bp = flask.Blueprint('health', __name__)


@health_bp.route('/ping/')
def ping():
    response = flask.jsonify(dict(response='pong'))
    response.set_data(response.get_data().rstrip("\n"))
    return response


@health_bp.route('/unistat/')
def unistat():
    data = unistat_agent.aggregate_stats(Stats.ALL_STATS)
    return flask.jsonify(data)


@health_bp.route('/public/echo/')
def echo():
    return flask.jsonify(dict(
        method=flask.request.method,
        url=flask.request.url,
        headers=dict(flask.request.headers),
        body=flask.request.data,
    ))