import asyncio

from aiohttp import web
from loguru import logger
from setproctitle import setproctitle

from server import app, start_dns_server
from settings import config
from utils.logconf import initialize_logging


def main():
    initialize_logging()
    logger.info('launching dns master')

    loop = asyncio.get_event_loop()
    try:
        if not config.http_master:
            setproctitle("dns_master")
            loop.run_until_complete(start_dns_server(host=config.dns.host, port=config.dns.port))
            logger.info(f'started dns server {config.dns.host}:{config.dns.port}')

        runner = web.AppRunner(app)
        loop.run_until_complete(runner.setup())

        site = web.TCPSite(runner=runner, host=config.web.host, port=config.web.port)
        loop.run_until_complete(site.start())
        logger.info(f'started http server {config.web.host}:{config.web.port}')

        loop.run_forever()
    except KeyboardInterrupt:
        pass
    finally:
        loop.stop()
        logger.info("stop dns master")


if __name__ == '__main__':
    main()
