import socket

from pydantic import BaseSettings


class LoggingSettings(BaseSettings):
    file_enabled: bool = True
    file_path: str = 'dns_master.log'
    file_rotation_rule: str = '100 MB'
    file_retention_count: int = 5

    stdout_enabled: bool = True
    stdout_json_formatted: bool = False


    class Config:
        env_prefix = 'log_'


class DNSSettings(BaseSettings):
    port: int = 53
    host: str = '::'

    class Config:
        env_prefix = 'dns_'


class WebSettings(BaseSettings):
    port: int = 80
    host: str = '::'

    class Config:
        env_prefix = 'web_'


class DBSettings(BaseSettings):
    connect_retry: int = 3
    pool_size: int = 5
    pool_max_overflow: int = 5
    pool_echo: bool = False
    echo: bool = False

    name: str = ''
    master_host: str = ''
    hosts: str = ''
    port: int = 5432
    user: str = ''
    password: str = ''
    ssl_mode: str = 'disable'

    class Config:
        env_prefix = 'db_'


class Settings(BaseSettings):
    env: str
    hostname = socket.gethostname()
    logging: LoggingSettings = LoggingSettings()
    db: DBSettings = DBSettings()
    dns: DNSSettings = DNSSettings()
    web: WebSettings = WebSettings()
    http_master: bool = False
