import os

from settings.base import DBSettings


def get_engine_url(settings: DBSettings, host: str) -> str:
    connect_str = (
        f'postgresql+asyncpg://{settings.user}:{settings.password}@'
        f'{host}:{settings.port}/{settings.name}?ssl={settings.ssl_mode}'
    )

    return connect_str

class HostManager:
    def __init__(self, settings: DBSettings):
        self._settings = settings
        self.hosts = list(map(lambda a: a.strip(), self._settings.hosts.split(',')))
        self.current_replica_host = None
        self.current_dc = self.get_current_dc()

    def get_current_dc(self):
        dc = os.getenv('DEPLOY_NODE_DC', '')
        return dc.lower()

    def get_replica_host(self) -> str:
        """ получаем хост БД в этом же ДЦ, если реплика недоступна, выбираем следующий по списку просто """
        if len(self.hosts) < 2:
            return self.hosts[0]

        if self.current_replica_host:
            self.hosts.remove(self.current_replica_host)

        for host in self.hosts:
            if self.current_dc in host:
                self.current_replica_host = host
                return host

        self.current_replica_host = self.hosts[0]
        return self.current_replica_host

    def get_master_host(self) -> str:
        return self._settings.master_host

class IteratorJSONAdapter(list):
    def __init__(self, iter):
        super(IteratorJSONAdapter, self).__init__()
        self.__iter = iter

    def __len__(self):
        return 1

    def __iter__(self):
        return self

    def __next__(self):
        return next(self.__iter)
