import socket

from pydantic import BaseSettings


class LoggingSettings(BaseSettings):
    file_enabled: bool = True
    file_path: str = "/app/log/nsd_manager.log"
    file_rotation_rule: str = "100 MB"
    file_retention_count: int = 5

    stdout_enabled: bool = True
    stdout_json_formatted: bool = False


    class Config:
        env_prefix = "log_"


class NSDSettings(BaseSettings):
    port: int = 8952
    host: str = "::1"
    crt: str = "/etc/nsd/nsd_control.pem"
    key: str = "/etc/nsd/nsd_control.key"

    class Config:
        env_prefix = "nsd_"


class WebSettings(BaseSettings):
    port: int = 8080
    host: str = "::"

    class Config:
        env_prefix = "web_"



class Settings(BaseSettings):
    env: str
    hostname = socket.gethostname()
    logging: LoggingSettings = LoggingSettings()
    nsd: NSDSettings = NSDSettings()
    web: WebSettings = WebSettings()

    skip_update_db: bool = False
    init_stuck_zones_count: int = 1000  # количество зон которые могут быть не загружены на старте
    init_sleep_time: int = 600  # сколько секунд ждем между запросами zonestatus в init секции
    dns_master_url: str = "http://dns-master.prod.ws.yandex.net"
    zone_list_path: str = "/persistent/data/nsd/zone.list"
    tcp_fd_stuck: bool = False  # если в True то в stuck_zones учитываем зоны у которых  transfer == waiting-for-TCP-fd
    init_pid_path: str = "/var/run/init_nsd.pid"
