#!/usr/bin/env bash

set -e

source /opt/dns-hosting/bin/activate

echo "Making all virtual environment shell-scripts executable..."
chmod +x /opt/dns-hosting/bin/*.sh

echo "Installing CA..."
mkdir -p  /usr/share/ca-certificates/extra
cp /opt/dns-hosting/certificates/yandex.crt /usr/local/share/ca-certificates/yandex.crt
update-ca-certificates

echo "Installing PostgreSQL CA..."
mkdir -p /root/.postgresql
cp -f /usr/local/share/ca-certificates/yandex.crt /root/.postgresql/root.crt
chmod 0600 /root/.postgresql/root.crt

if [ -d profiles ]; then
    echo "Copying generated profiles to interpreter directory..."
    mkdir -p /opt/dns-hosting/profiles
    cp -f profiles/application-*.yml /opt/dns-hosting/profiles/
fi

echo "Rendering profiles..."
for TMPL in $(find /opt/dns-hosting/profiles -name '*.jinja2'); do
    DEST=$(echo "$TMPL" | sed 's/\.jinja2$//')
    DEST_DIR=$(dirname "$DEST")
    echo "Rendering profile $TMPL..."
    mkdir -p "$DEST_DIR"
    chmod -R 0755 "$DEST_DIR"
    wsprop template -s "$TMPL" -d "$DEST"
    chmod -R 0644 "$DEST"
done

echo "Rendering templates..."
for TMPL in $(find /opt/dns-hosting/templates -name '*.jinja2'); do
    DEST=$(echo "$TMPL" | sed 's/^\/opt\/dns-hosting\/templates//' | sed 's/\.jinja2$//')
    DEST_DIR=$(dirname "$DEST")
    echo "Rendering template $TMPL..."
    mkdir -p "$DEST_DIR"
    chmod -R 0755 "$DEST_DIR"
    wsprop template -s "$TMPL" -d "$DEST"
    chmod -R 0644 "$DEST"
done

echo "Calling prepare hooks..."
for hook_file in $(find /opt/dns-hosting/hooks/ -name '*.sh' | sort); do
    echo "Calling prepare hook: $hook_file"
    source $hook_file
done

echo "Active profiles:"
/opt/dns-hosting/bin/wsprop profiles | xargs -n 1 echo '*'

if [ -n "$PGPASS_FILE" ] ; then
    echo "Adding pgpass"
    echo "$PGPASS_FILE" > /root/.pgpass 
    chmod 600 /root/.pgpass
fi

if [ -n "$1" ]; then
    echo "Starting application..."
    exec "$@"
fi
