#!/usr/bin/env bash

set -e

export APPLICATION_PROFILES_ACTIVE=unittest

source /opt/dns-hosting/bin/activate

/etc/init.d/postgresql start

su -c 'yes "internal_pwd" | createuser internal_user -P' postgres
su -c 'createdb workspace_dns -O internal_user -T template0 --lc-collate C --lc-ctype C' postgres
su -c 'psql -d workspace_dns -c "CREATE EXTENSION IF NOT EXISTS btree_gist WITH SCHEMA public;"' postgres

dnscli pgmigrate migrate -t latest

exec python -m unittest discover
