# encoding: UTF-8

from ws_properties.conversion.converter import CompositeConverter
from ws_properties.conversion.converter import Converter
from ws_properties.conversion.converter import ToBoolConverter
from ws_properties.conversion.converter import ToDateConverter
from ws_properties.conversion.converter import ToDateTimeConverter
from ws_properties.conversion.converter import ToEnumConverter
from ws_properties.conversion.converter import ToFloatConverter
from ws_properties.conversion.converter import ToIntegerConverter
from ws_properties.conversion.converter import ToTimeConverter
from ws_properties.conversion.converter import ToTimeDeltaConverter


class ConversionService(Converter):
    def __init__(self):
        self.__converter = CompositeConverter()
        self._customize_converters(self.__converter.converters)

    @property
    def converters(self):
        return self.__converter.converters

    def _customize_converters(self, converters):
        pass

    def convert(self, source, target_type, **hints):
        return self.__converter.convert(source, target_type, **hints)


class StandardConversionService(ConversionService):
    def _customize_converters(self, converters):
        converters.extend([
            ToEnumConverter(),
            ToDateTimeConverter(),
            ToDateConverter(),
            ToTimeConverter(),
            ToTimeDeltaConverter(),
            ToBoolConverter(),
            ToIntegerConverter(),
            ToFloatConverter(),
        ])
