# encoding: UTF-8

import __builtin__
import importlib


def import_module_attr(path):
    nodes = path.split('.')
    module = '.'.join(nodes[:-1])
    attr = nodes[-1]
    module = importlib.import_module(module) if module else __builtin__
    try:
        return getattr(module, attr)
    except AttributeError:
        raise ImportError('Module has no attribute named \'%s\'' % attr)


def get_type(value):
    if isinstance(value, (str, unicode)):
        value = import_module_attr(value)

    if isinstance(value, type):
        return value
    else:
        raise ValueError('Value %r can not be transformed to type' % value)
