# encoding: UTF-8

import logging


def get_logger_for_class(cls):
    name = cls.__module__ + '.' + cls.__name__
    return logging.getLogger(name)


def get_logger_for_instance(instance):
    cls = instance.__class__
    return get_logger_for_class(cls)
