JAVA_PROGRAM(disk)

INCLUDE(${ARCADIA_ROOT}/disk/support/common_header.inc)

OWNER(g:disk)

PEERDIR(
    disk/eventloader
    disk/download-stat
    disk/notifier
    disk/balancer
    disk/log-reader
    disk/countersapi
    disk/queller
    disk/worker2
    disk/uploader
    disk/videostreaming
    disk/urlshortener
    disk/webdav
    disk/djfs
    disk/docviewer
    disk/notes
    disk/telemost

    disk/qa/ps-billing

    disk/ps-billing/core
    disk/ps-billing/worker
    disk/ps-billing/web

    disk/support/common
    disk/support/bazinga
    disk/support/eventlog
    disk/support/dataapi
    disk/support/ydb-common

    disk/dataapi/backend
    disk/dataapi/worker
    disk/dataapi/admin

    disk/lenta/backend
    disk/lenta/worker

    disk/smartcache/client
    disk/smartcache/worker

    disk/axis/factapi
    disk/axis/factprocessor

    iceberg/commune
    iceberg/commune-a3
    iceberg/commune-a3-admin
    iceberg/commune-admin
    iceberg/commune-admin-all
    iceberg/commune-alive
    iceberg/commune-archive
    iceberg/commune-arquebus
    iceberg/commune-bazinga
    iceberg/commune-bazinga-pg
    iceberg/commune-db
    iceberg/commune-dynproperties
    iceberg/commune-jparsec
    iceberg/commune-json
    iceberg/commune-mail
    iceberg/commune-mongo3
    iceberg/commune-mongo
    iceberg/commune-monica
    iceberg/commune-object-printer
    iceberg/commune-protobuf5
    iceberg/commune-random
    iceberg/commune-rpc
    iceberg/commune-script
    iceberg/commune-web-zscript
    iceberg/commune-universal-object-parser
    iceberg/commune-uploader
    iceberg/commune-image
    iceberg/commune-zk
    iceberg/commune-zk-admin

    iceberg/bolts
    iceberg/misc
    iceberg/misc-apache-http-client-4
    iceberg/misc-db
    iceberg/misc-cache
    iceberg/misc-corba
    iceberg/misc-geo
    iceberg/misc-http-client-common
    iceberg/misc-jetty
    iceberg/misc-main
    iceberg/misc-worker
    iceberg/misc-bender
    iceberg/misc-bender-annotations
    iceberg/misc-spring
    iceberg/misc-xml
    iceberg/misc-mime-detect
    iceberg/misc-async-http-client-2
    iceberg/inside-bunker
    iceberg/inside-client-utils
    iceberg/inside-conductor
    iceberg/inside-elliptics
    iceberg/inside-geobase
    iceberg/inside-geocoder
    iceberg/inside-mulca
    iceberg/inside-network-map
    iceberg/inside-passport
    iceberg/inside-tanker
    iceberg/inside-yt
    iceberg/inside-solomon
    iceberg/inside-mds
    iceberg/inside-wmi
)

INCLUDE(${ARCADIA_ROOT}/disk/support/exclude.inc)
INCLUDE(${ARCADIA_ROOT}/disk/support/lombok.inc)

JAVA_SRCS(SRCDIR devel **/*)

END()

RECURSE(
    support
    smartcache
    eventloader
    dataapi
    download-stat
    notifier
    balancer
    log-reader
    countersapi
    queller
    worker2
    uploader
    lenta
    videostreaming
    urlshortener
    webdav
    djfs
    axis
#   hancom
    notes
    grelka
    monops
    docviewer
    cvdemo2
    admin
    admin-idm-api
    migrator
    uaas
    fotki
    ydbtest
    djfs-migrator
    downloader
    hackathon_2019_1
    bazinga-load
    mpfs
    ps-billing
    telemost
    telemost-conference-manager
    orchestrator
    tasklets
    qa
)

#IF(LINUX)
#    RECURSE(
#        cvdemo
#        cvyt
#    )
#ENDIF()
