package ru.yandex.chemodan.app.ydbtest;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.misc.db.monica.JdbcMetricsSwitch;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author tolmalev
 */
public class YdbtestMain extends ChemodanMainSupport {

    public static void main(String[] args) {
        JdbcMetricsSwitch.ENABLED = true;
        new YdbtestMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("disk", "ydbtest");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(
                ChemodanCommonContextConfiguration.class,
                YdbtestMainContextConfiguration.class);
    }

    @Override
    protected void configureLogger() {
        Log4jHelper.rootLoggerBuilder().appName(applicationName()).bufferSize(2 * 1024 * 1024).build();

        Log4jHelper.accessLoggerBuilder().bufferSize(2 * 1024 * 1024).appName(applicationName()).build();
    }
}
