package ru.yandex.chemodan.app.ydbtest;

import com.yandex.ydb.core.auth.TokenAuthProvider;
import com.yandex.ydb.core.grpc.GrpcTransport;
import com.yandex.ydb.core.rpc.RpcTransport;
import com.yandex.ydb.table.TableClient;
import com.yandex.ydb.table.rpc.grpc.GrpcTableRpc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        A3JettyContextConfiguration.class
})
public class YdbtestMainContextConfiguration {

    @Autowired
    @Qualifier("a3Jetty")
    private SingleWarJetty jetty;

    @Bean
    public YdbtestServlet ydbtestServlet(TableClient tableClient) {
        YdbtestServlet servlet = new YdbtestServlet(tableClient);
        jetty.addServletMapping("/ydb/*", servlet);
        return servlet;
    }

    @Bean(destroyMethod = "close")
    public TableClient ydbTableClient(
            @Value("${ydb.token}") String token,
            @Value("${ydb.endpoint}") String endpoint,
            @Value("${ydb.database}") String database)
    {
        RpcTransport transport = GrpcTransport.forEndpoint(endpoint, database)
                .withAuthProvider(new TokenAuthProvider(token))
                .build();

        return TableClient.newClient(GrpcTableRpc.ownTransport(transport))
                .sessionPoolSize(10, 100)
                .build();
    }
}
