# FAQ

## Q: Флаг указанный здесь не применился там {#deps_order}

**A:** Часто возникает вопросы вида:
 * "Я указал `CFLAGS` в своей программе, а вот на эту библиотеку которая в ней используется эти флаги не проросли."
 * "Как мне в моём тесте попросить собрать программу используемую в рецепте без санитайзеров/с кастомными флагами?"

Во всех этих случаях ответ один и тот же: никак. Это фундаментальное ограничение нашей системы сборки, которое обусловлено необходимостью
предсказуемо масштабироваться с ростом размеров Аркадии. Проблемы которые возникают если разрешить индуцирование свойств с потребителя на
зависимость следующие:
 * Разные потребители могут индуцировать разные свойства, а значит любую библиотеку может потребоваться пересобрать много раз в разных
   конфигурациях. Это требует существенно больших объёмов вычислительных ресурсов и дискового пространства под кэши чем текущая модель.
 * Предсказать стоимость добавления/изменения одной строчки в ya.make становится крайне сложно. Правка макроса `CFLAGS` на программе может
   как существенно сократить объём сборки (если раньше эта программа задавала уникальную комбинацию флагов, а теперь её комбинация стала
   совпадать с комбинацей флагов другой программы), так и существенно увеличить. Невинно выглядящий однострочный коммит который требует
   увеличить ресурсы автосборки по железу на 10% это то, с чем мы просто не сможем существовать и развиваться.
 * Возможность индуцировать свойства на свои зависимости порождает проблему с конфликтующими требованиями в ромбовидной
   зависимости. Если одна библиотека хочет свои зависимости собрать с одним набором флагов, а другая с другим и у них пересекающееся множество
   зависимостей, то не понятно как должны будут собираться любые библиотеки или программы которые зависят от двух этих библиотек одновременно.
   Эта проблема разумеется не возникает если индуцировать зависимости разрешено только финальным целям (таким как программы или динамические 
   библиотеки), но не промежуточным (таким как обычные библиотеки).

Подробно о том как распространяются свойства между модулями написано в разделе описывающем [построение графа зависимостей](how_it_works.md#build_deps).

## Q: Как объединять unittest-ы? Хочется удобно запускать набор unittest-ов {#multy_test}

**A:** Если есть необходимость семантически объединить `path/to/proj/ut`, предлагается создавать `ya.make`, следующего содержания:

```
RECURSE_ROOT_RELATIVE(
    path/to/proj1/ut
    path/to/proj2/ut
    ...
    path/to/projN/ut
)
```

## Q: Как сделать в одном ya.make одновременно LIBRARY/PROGRAM/UNITTEST? {#embed_test}

**A:** Никак. В одном  `ya.make` может быть только один модуль. Это служит цели структурирования кода, и не позволяет случайным образом поиспользовать файл не из модуля.
