# С чего начать

Чтобы начать пользоваться сборкой ya make в Аркадии достаточно создать локальную рабочую копии Аркадии по [инструкции](https://docs.yandex-team.ru/devtools/intro/quick-start-guide)

Для разработчиков на go есть расширенная [инструкция](https://wiki.yandex-team.ru/devrules/Go/getting-started/)

## Как построить первый проект

Если локальная рабочая копия Аркадии расположена в папке `arcadia`, то сборка первого проекта может выглядеть примерно так:

```
[=] cd arcadia
[=] ya make devtools/examples/tutorials/cpp/hello
ok
[=] devtools/examples/tutorials/cpp/hello/hello
Hello world
```

Чтобы собрать любой проект достаточно вместо `devtools/examples/tutorials/cpp/hello` указать папку проекта, с которым вы будете работать.

{% note tip %}

По умолчанию сборка выполняется в режиме для отладки (режим *debug*). Если вы хотите собрать программу для использования, а не для отладки рекомендуем собирать её с оптимизациями (режим *release*),
добавив флаг `-r` в командную строку сборки.

{% endnote %}


Подробнее про возможности, доступные при запуске сборки, можно прочитать [здесь](../usage/ya_make/index.md)

## Как запустить первые тесты

Запустить тесты не сложнее, чем запустить сборку. Выглядит это примерно так:

```
[=] cd arcadia
[=] ya make -t devtools/examples/tutorials/cpp/hello-with-test

Total 1 suite:
        1 - GOOD
Total 2 tests:
        2 - GOOD
Ok
```

{% note tip %}

Для системы сборки все тесты размечены их `ya.make` размером (макрос `SIZE`) — по умолчанию тесты `SMALL` (маленькие) и должны укладываться в 1 минуту на всю сюиту. Более длинные тесты — `MEDIUM` (средние) с лимитом 10 минут.
Самые большие — `LARGE` с лимитом 1 час. `ya make -t` запустит только маленькие тесты. Для запуска ещё и средних нужно использовать `-tt`, для запуска всех тестов `-ttt` или `-A`. 

{% endnote %}

## Как написать первый ya.make

Для того, чтобы начать описывать свои проекты для системы сборки `ya make` рекомендуем ознакомиться с пошаговыми руководствами для разных языков:

- [Описание сборки на C++](../tutorials/cpp.md)
- [Описание сборки на Python](../tutorials/python.md)
- [Описание сборки на Java](../tutorials/java.md)
- [Описание сборки на Go](../tutorials/go.md)

## Узнать больше о системе сборки

Чтобы лучше понять систему сборки можно почитать:

[Базовые понятия и принципы](base_concepts.md)
[Как работает система сборки](how_it_works.md)
[Описание проектов для ya make в детялях](../manual/index.md)
