# Общее для всех языков

Существенная часть конструкций (модулей и макросов) `ya.make` ориентирована на поддержку сборки определённого языка ([C++](../cpp), [Python](../python), [Java](../java), [Go](../go))
или технологии ([protobuf](../proto), [flatbuf](../flatbuf)). Однако самые базовые макросы и правила применимы ко всем языкам.

- Макросам и модулям для [тестирования](../tests) и [агрегирования](../package) посвящены отдельные разделы.
- Других [общих для всех языков модулей](./modules) практически нет, за [одним исключением](./modules).
- [Сборочных макросов, общих для всех языков](./macros), напротив достаточно много. Они позволяют задавать переменные, управлять интерпретацией ya.make, задавать зависимости, управлять межмодульными правилами,
а также реализовывать общую генерацию исходного кода (на любом языке) и подвоз готовых данных из Sandbox.
- Многие встроенные [переменные](./vars) также имеют смысл для всех языков.
- Кроме конструкций `ya.make` в этом разделе описаны [правила контроля зависимостей](./rules) они позволяют изолировать реализации проектов от интерфейсов, а также поддерживать порядок в репозитории предоставляя доступ только к одобренным общим библиотекам.
