# Обработка файлов по расширениям

Сиистема сборки ya.make ориентируется на расширения файлов.

- По расширениям она [добавляет комнады для файлов](#srcs) в макросе [`SRCS`](common/macros.md#srcs) и при автоматической обработке промежуточных результатов.
- По расширениям [обрабатываются файлы в PY_SRCS и JAVA_SRCS](#py)
- По расширениям файлы [становятся входами модульных команд](#auto)
- По расширеням применятся [анализ зависимостей для исходных файлов](#parsing)


## Автоматические команды обработки файлов по расширениям { #srcs }

Макрос [`SRCS`](common/macros.md#srcs) обрабатывает файлы в соответствии с их расширениями. Более того,
в определённых случаях может меняться его поведении в зависимости от типа модуля, в котором его используют.

Также, если расширение зарегистрировано для [`SRCS`](common/macros.md#srcs), то файлы, появляющиеся в сборке как результаты команд, будут обработаны аналогично.

Макрос [`SRCS`](common/macros.md#srcs) для каждого файла формирует команду. В таблице ниже описано какая команда будет сформирована и какое расширение будет у её результата.
Контекст — это модули, в которых работает это правило. Общий — это макросы `LIBRARY`, `PROGRAM`, `PYx_LIBRARY`, `PYx_PROGRAM`, `UNION`/`PACKAGE` и многие другие,
примерно все кроме `PROTO_LIBRARY`, `FBS_LIBRARY`, модулей для Java и Go.

Расширения | Обработчик  | Результат | Контекст
:--- | :--- | :--- | :---
`.c`, `.m` | компилятор С | `.o`/`.obj` | Общий
`.cpp`, `.cc`. `.cxx`, `.C` | компилятор C++ | `.o`/`.obj` | Общий
`.rl`, `.rl6` | ragel | `.c` | `LIBRARY`, `PROGRAM`, `PYx_LIBRARY`, `PYx_PROGRAM`,...
`.proto` | protoc | `.pb.cc`, `.pb.h`,... | `LIBRARY`, `PROTO_LIBRARY`/`CPP_PROTO`
`.proto` | protoc | `_pb2.py`, `pb2.pyi`,... | `PYxLIBRARY`, `PROTO_LIBRARY`/`PYx_PROTO`
`.proto` | protoc | `.jsrcs` | `PROTO_LIBRARY`/`JAVA_PROTO`
`.proto` | protoc | `.pb.go`, ... | `GO_LIBRARY`, `PROTO_LIBRARY`/`GO_PROTO`
`.S`, `.s`, `.s79`,  |  компилятор С  | `.o`/`.obj` | Общий
`.mm`  |  компилятор C | `.o`/`.obj` | Общий
`.fml`, | Транслятор формул | `fml.inc` | Общий
`.fml2` | Транслятор формул | `fml.inc`, Общий
`.fml3` | Транслятор формул | `fml.inc`, Общий
`.pln` | Транслятор формул | `pln.cpp` | Общий
`.sdfl` | компилятор C++ и tools/calcstaticopt | .o и.inc | Общий
`.xs` | Perl | `xs.c` или `xs.cpp` | Общий
`.y`, `.ypp` | byacc | `.y.cpp`, `.h` | Общий
`.gperf` | gperf | `.gperf.cpp` | Общий
`.rl`, `.rl5` | Ragel5 | `rl.cpp` | Общий
`.asp` | html2cpp | `asp.cpp` | Общий
`.rl6` | Ragel6 | `rl6.cpp` | Общий
`.l`, `.lex`, `.lpp` | flex | Общий
 `xsyn` | xsyn2ragel | `.rl5` | Общий
`.ev` | protoc | `.ev.pb.cc`, `.ev.pb.h`,... | `LIBRARY`, `PROTO_LIBRARY`/`CPP_PROTO`
`.ev` | protoc | `_ev.py`, `_ev.pyi`,... | `PYxLIBRARY`, `PROTO_LIBRARY`/`PYx_PROTO`
`.ev` | protoc | `.jsrcs` | `PROTO_LIBRARY`/`JAVA_PROTO`
`.gztproto` | dict/gazetteer/converter | `.proto` | Общий
`.cfgproto` | protoc | `.cfgproto.pb.cc`, `.cfgproto.pb.h`,... | Общий
`.pyx` | Cython | `.pyx.cpp` | `SRCS` в `PYMPODULE`, `LIBRARY`, `DLL`, `PY23_NATIVE_LIBRARY`
`.ext.in` | Из `*.ext.in`  получается `*.ext`  путем копирования `*.ext.in`  с заменой `@CONFIG_VAR@` на значение этой переменной в системе сборки | `.ext` | Любой
`.sc` | `tools/domschemec` | `.h` | Общий
`.ssqls` | `metrika/core/tools/ssqls` | `.h`, `.cpp` | Общий
`.f` | Fortran f2c | `.c` | Общий
`.masm` | masm | `.o`/`.obj` | Общий
`.asm`, `.yasm` | yasm | `.o`/`.obj` | Общий
`.lua` | LuaJIT |  `.o` | Общий
`.cu` | CUDA nvcc |  `.o` | Общий
`.fbs` | protoc | `.fbs.h` | `LIBRARY`, `FBS_LIBRARY`/`CPP_FBS`
`.fbs` | protoc | `.pysrcs` | `PYxLIBRARY`, `FBS_LIBRARY`/`PYx_FBS`
`.fbs` | protoc | `.jsrcs` | `FBS_LIBRARY`/`JAVA_FBS`
`.fbs` | protoc | `.gosrcs` | `GO_LIBRARY`, `FBS_LIBRARY`/`GO_FBS`
`.fbs64` | protoc | `.fbs64.h` | Общий

## Автоматические модульные входы { #auto }

Модульная конфигурация определяет файлы с какими расширениями будут её входами. Если в процессе [обработки по расширениям](#ext) появляется файл с таким расширением,
то обработка останавливается и файл становится **автоматическим входом** команды сборки модуля. Все такие входы формируют список имён, и он подаётся в модульную команду. 

Даже если для файла существует дальнейшая обработка, если расширение файла предписано модулю, обработка не будет запущена и файл будет отправлен в модульную команду.


Модули | Расширения
:--- | :--- 
`PROGRAM`, `LIBRARY` | .o, .obj 

## Анализ зависимостей по расширениям { #parsing }

Описание сборки в `ya make` очень высокоуровневое, она не требует описания зависимостей файлов от других файлов (например, `#include` в C++ или `import` в Protobuf), 
если исходный файл доступен на файловой системе. Система сборки сама анализирует исходные файлы, основываясь на расширениях и находит зависимости. Более того, система
сборки может выводить межмодульные зависимости (в go), а также *[наведённые](index.md#induced)* зависимости генерируемых файлов от других генерируемых. Так из `import` в .proto система сборки делает вывод не только о зависимости между .proto-файлами, но и о зависимости .pb.cc файла от импортируемого .pb.h.

Ниже в таблице собрана информация о том какие расширения и как анализируются. Колонки в таблице означают следующее:

- **Расширение** -- список типов файлов, к которым это правило применяется.
- **Зависимости** -- список типов файлов, прямые зависимости от которых, умеет обнаруживать система сборки.
- **Наведённые** -- список типов файлов, для которых выводятся [наведённые зависимости](index.md#induced).
- **Распространение** -- могут ли наведённые зависимости распространяться через такие файлы. Если файл с таким расширением зависит от источника [наведённых зависимостей](index.md#induced),
  должны ли эти зависимости применяться к тем, кто зависит от этого файла.
- **Язык в `ADDINCL`** -- в макросе [`ADDINCL`](common/macros.md#addicl) можно указать к каким файлам данный путь поиска относится. Это делается указанием *языка* в параметре `FOR`.
  В колонке обозначено какой язык будет применяться для разрешения имён при обработке файлов в соответствующей строке.

Расширение | Зависимости | Наведённые  | распространение | Язык в `ADDINCL` | Описание
:--- | :--- | :--- | :--- | :--- | :---
`fml`, `fml2`, `fml3`, `pln`, `info`, `a`, `lua`, `sh` | нет | нет | нет | -- | Останавливают распространение зависимостей
`bin`, `py` | нет | нет | да | -- | Пропускают зависимости
`.c`, `.cc`, `cxx`, `.cpp`, `C` | `.h`, `hh`, `hpp`,... | -- | нет | `с`/нет | C/C++
`.h`, `.hh`, `.hpp`, `.cuh`, `.H`, `.hxx`, `.xh` | `.h`, `hh`, `hpp`,... | `.h`, `.cpp`, `.xscpp` | нет | `с`/нет | Заголовочные файлы
`.cu`, `.S`, `.s`, `.sfdl`, `.m`, `.mm` | `.h`, `hh`, `hpp`,... | `.h`, `.cpp` | нет | `с`/нет | Синтаксически похожи на С
`.asm` | `.asm` | нет | нет | `asm` | Ассемблер yasm
`.proto` | `.proto` | `pb.cc`, `pb.h` | нет | `proto` | Protobuf
`.ev` | `.proto` | `.ev.pb.cc`, `.ev.pb.h` | нет | `proto` | Events на основе protobuf
`.gzt`, `.gztproto` | `.proto` | нет | нет | `proto` | Конфиги на основе protobuf
`.cfgproto` | `.proto` | `.cfgproto.pb.cc`, `.cfgproto.pb.h` | нет | `proto` | Схемы для газеттира
`l`, `lex`, `lpp`, `.y`, `.ypp`, `gperf`, `.asp` | нет | `.cpp`  | нет | `c`/нет | lex, yacc, google perf, asp -- все генерируют код на С/C++
`rl`, `rh`, `rli`, `rl6`, `rl5` | `rl`, `rh`, `rli`, `rl6`, `rl5` | `.cpp` | нет | `ragel`  | Ragel
`.f` | нет | `.c` | нет |  `c`/нет | Fortan через f2c
`.xs` | нет  |  `.cpp`, `xscpp` | нет | `xs` | Perl to C биндинги
`.xscpp` | нет | `.cpp` | да  | `xs` | Perl to C++ биндинги
`.xsyn` | `.xsyn` | нет | нет | `xsyn` | XML
`.pyx` | `.pyx`, `.pxd` | `.cpp,`, `.h` | да | Cython
`.swg` |`.swg`, `.i` | `.h` , `.cpp` | нет | `swig` | SWIG биндинги для Python и Java
`.fbs` | `.fbs` | `.fbs.h` | нет | `flatc` | Flatbuffers
`.fbs64` | `.fbs64` | `.fbs64.h` | нет | `flatc` | 64-битный вариант Flatbuffers
`.go` | `.go` | `PEERDIR`, `.C` | нет | `c`/нет | Go
`.ts`, `.js`, `.tsx`, `.jsx` |`.ts`, `.js`, `.tsx`, `.jsx` | нет | нет | нет | Frontend-файлы, только в модулях под сборкой Frontend
`.sc` | `.sc` | нет | нет | `sc` | sc-схемы
`.ydl` | `.ydl` | `.h` | нет | `ydl` | ydl-схемы
`.nlg` | `.nlg` | `.h` | нет | `nlg` | nlg-схемы
`idl` | `idl` | `.h` | нет | `idl` | Mapkit IDL



## Расширения в `PY_SRCS` и `JAVA_SRCS` { #py }

Макросы [`PY_SRCS`](python/macros.md#py_srcs) и [`JAVA_SRCS`](java/macros.md#java_srcs) поддерживают свои наборы расширений, который могу специально обрабатывать.

### `PY_SRCS`

- `.py` -- компилируется с помощью pycc и складывается ресурсом доступным для импорта [программами на Python](python/index.md#python_program)
- `.pyc` -- компилируется с помощью cython и регистрируется, чтобы код был доступным для импорта [программами на Python](python/index.md#python_program)
- `.swg` -- компилируется с помощью swig и регистрируется, чтобы код был доступным для импорта [программами на Python](python/index.md#python_program)
- `.proto` -- генерируется код на Python, затем обрабатывается как `.py`
- `.fbs` -- генерируется код на Python (множество файлов), затем они компилируются и складываются в ресурсы доступные для импорта [программами на Python](python/index.md#python_program)

