# Описание сборки Flatbuffers

## FBS_LIBRARY
Сборка [Flatbuffers](https://google.github.io/flatbuffers/) в `Аркадии` поддержана для всех официальных языков (`C++`, `Go`, `Java`, `Python`). Для кросс-языковой сборки `Flatbuffers` в Аркадии определён мультимодуль [FBS_LIBRARY](modules.md#fdb_library). Такой мультимодуль позволяет легко описывать сериализацию/десериализацию данных на разных языках программирования, используя одну и ту же схему данных. Все файлы (`.fbs` файлы) необходимые для сборки должны быть перечислены в вызове макроса [SRCS](macros.md#srcs). При построении каждого подмодуля, участвующего в сборке, для таких файлов автоматически запускаются команды кодогенерации (`flatc`) и дальнейшей обработки сгенерированных файлов в соответствии с типом подмодуля.

Пример описания `FBS_LIBRARY`:
```
OWNER(g:ymake)

FBS_LIBRARY()

SRCS(
    api.fbs
)

END()
```

## Ограничения для FBS_LIBRARY
Есть несколько ограничений на сборку `FBS_LIBRARY`:
1) В `.fbs` файлах, указанных в [SRCS](macros.md#srcs) для `FBS_LIBRARY`, может быть определён только один namespace.
2) `FBS_LIBRARY` может зависеть только от `FBS_LIBRARY`.
3) Если `FBS_LIBRARY` зависит от других `FBS_LIBRARY` и требуется построение для `Go`, то для всех зависимостей (`FBS_LIBRARY`) в файлах описания сборки должен быть явно указан `Flatbuffers` namespace посредством вызова макроса [FBS_NAMESPACE](macros.md#fbs_namespace) (Пример можно посмотреть [здесь](https://a.yandex-team.ru/arc/trunk/arcadia/devtools/dummy_arcadia/fbs/fbs_library_with_deps)).

## Поддержка Flatbuffers в основных модулях
Для добавления `Flatbuffers` в сборку проекта достаточно добавить файлы описания схем - `.fbs` файлы - в вызов макроса [SRCS](macros.md#srcs) ([PY_SRCS](../python/macros.md#py_srcs) - для `Python`).

{% note warning %}

Несмотря на то что `.fbs` файлы можно использовать в *основных* модулях, мы настоятельно рекомендуем использовать [FBS_LIBRARY](modules.md#fbs_library)в своих проектах - это позволит избежать копирования и "воровства" `.fbs` и предотвратит нежелательные *спецэффеты* в работе IDE.

{% endnote %}

Пример описания сборки для Python:
```
OWNER(g:ymake)

PY3_LIBRARY()

PY_SRCS(
    __main__.py
    data.fbs
)

END()
```

## Промежуточные (генерированные) файлы для Flatbuffers

Для того чтобы получить промежуточные файлы сборки - результат кодогенерации `flatc` достаточно в команде запуска построения `ya make ...` указать дополнительный флаг `--add-flatbuf-result`. В зависимости от того какие модули участвуют в сборке в директории модуля появятся файлы (или символические ссылки на них) c расширениями:
Расширение | ЯП
:--- | ---:
.fbs.h | C/C++
.fbs.gosrc | Go
.fbs.jsrc | Java
.fbs.pysrc | Python

{% note info %}

Промежуточные файлами генерации для `Go` и `Python` имеют расширения `.fbs.gosrc` и `.fbs.pysrc` - это tar архивы исходных файлов, сгенерированных `flatc`. При использовании флагов `--add-flatbuf-result` (это также верно для `--add-result .gosrc` или `--add-result .pysrc`) кроме самих файлов `.fbs.gosrc` или `.fbs.pysrc` (или символических ссылок на них) в директория модуля будут также размещены файлы из архивов).

{% endnote %}
