# Java : модули

## JAVA_LIBRARY

 * Собирает Java и Kotlin код из исходных файлов добавленных в проект через макрос [`JAVA_SRCS`](macros.md#java_srcs).
 * Запаковывает скомпилированные классы вместе с файлами ресурсов добавленных через [`JAVA_SRCS`](macros.md#java_srcs) в jar архив.

По умолчанию компиляция Kotlin выключена, для её включения требуется явно использовать макрос [`WITH_KOTLIN`](macros.md#with_kotlin).

Библиотека может зависеть от других `JAVA_LIBRARY`, `JAVA_PROGRAM` (если модуль не использует макрос `UBERJAR`), `PROTO_LIBRARY`, `EXTERNAL_JAVA_LIBRARY`, `DLL`, `DLL_JAVA`.

## JAVA_PROGRAM

Модуль ведёт себя аналогично `JAVA_LIBRARY` плюс к этому после компиляции кода и запаковки jar файла, складывает все зависимости времени исполнения в директорию рядом со сгенерированным артефактом и генерирует скрипт для запуска java приложения.

При использовании макроса [`UBERJAR`](macros.md#uberjar) классы всех зависимостей из classpath программы будут добавлены в jar файл самой программы.

## JTEST

Модуль описывающий тесты Java кода на 4 версии фреймворка junit.

Код модуля собирается аналогично тому как это делает `JAVA_LIBRARY`. Помимо этого, команда запуска тестов добавляется для вызова при сборке, если запрошена сборка с запуском тестов.

{% note info %}

Classpath запуска тестов отличается от classpath компиляции кода. Для того, чтобы узнать с какими зависимостями будет выполняться запуск теста, можно использовать команду [`ya java test-classpath`](commands.md#ya-java-test-classpath)

{% endnote %}

## JUNIT5

Модуль описывающий тесты Java кода на 5 версии фреймворка junit.

Код модуля собирается аналогично тому как это делает `JAVA_LIBRARY`. Помимо этого, команда запуска тестов добавляется для вызова при сборке, если запрошена сборка с запуском тестов.

{% note info %}

Classpath запуска тестов отличается от classpath компиляции кода. Для того, чтобы узнать с какими зависимостями будет выполняться запуск теста, можно использовать команду [`ya java test-classpath`](commands.md#ya-java-test-classpath)

{% endnote %}

## JAVA_CONTRIB_PROXY

Модуль описывающий стороннюю бибилиотеку неопределённой версии. В окончательную сборку такие модули не попадают никогда, их заменяют на конкретную версию данной библиотеки в процессе разрешения конфликтов версий сторонних библиотек. Всё, что содержится внутри данного типа модулей, это `RECURSE` с перечислением всех имеющихся в аркадии версий данной бибилиотеки (реальные версии всегда должны лежать в поддиректориях прокси библиотеки) и единственный `PEERDIR` на самую актуальную версию данной бибилиотеки.

{% note info %}

Модули данного типа в норме не должны писаться руками. Их создаёт и редактирует утилита `ya maven-import`.

{% endnote %}

## JAVA_CONTRIB

Модуль описывающий стороннюю бибилиотеку конкретной версии. Данный тип модуля привозит уже предсобранный JAR файл из sandbox либо использует лежащий в аркадии jar файл. При использовани sandbox в качестве источника jar файла необходимо указать ID ресурса через макрос `JAR_RESOURCE` если файл складывается в аркадию, то относительные путь к нему нужно указать через макрос `LOCAL_JAR`. Так же можно опционально указать источник `-sources.jar` для этого модуля используя макросы `SRC_RESOURCE` или `LOCAL_SOURCES_JAR`. Помимо указания jar файла со скомпилированной сторонней бибилоитекой позволяет указывать его зависимости через `PEERDIR` и управлять его транзитивными зависимостями через макросы `DEPENDENCY_MANAGEMENT` и `EXCLUDE`.

{% note info %}

Модули данного типа в норме не должны писаться руками. Их создаёт утилита `ya maven-import`.

{% endnote %}

## JAVA_CONTRIB_PROGRAM

Почти полностью аналогичен модулю [`JAVA_CONTRIB`](modules.md#JAVA_CONTRIB), но при этом позволяет использовать данный контриб в макросе `RUN_JAVA_PROGRAM`. Для дополнительного управления classpath'м запуска позволяет использовать макросы `JAVA_RUNTIME_PEERDIR` и `JAVA_RUNTIME_EXCLUDE`.

## EXTERNAL_JAVA_LIBRARY

```
EXTERNAL_JAVA_LIBRARY(Name)
```

Модуль, порождающий `.jar` из исходного кода не на `.java`, например с помощью кодогенерации.

Кодогенерирующий скрипт может:
- Сам породить .jar-файл. Этот .jar файл войдёт в результат
- Породить отдельные .java-файлы. Они будут откомпилированы.
- Породить .jsrs-файл - .tar-архив с исходными файлами на .java, они также будут откомпилированы.

Результаты всех компиляций и .jar-ы войдут в результирующий .jar-файл с именем `Name`.jar.

{% note tip %}

В отличие от обычной [`JAVA_LIBRARY`](#java_library) такие библиотеки не порождают `.pom`-файлов и потому не могут, например, быть экспортированы в Maven.
Используйте [`PEERDIR`](../common/macros#peerdir) из [`JAVA_LIBRARY`](#java_library) или [`JAVA_PROGRAM`](#java_library) для экспорта в Maven.

{% endnote %}
