# Специфика сборки с CUDA

CUDA Toolkit (далее просто CUDA) нужен для сборки кода под различные GPU компании NVidia. По общепринятому соглашению, такой код хранят в файлах с расширением `*.cu`. Если в проект аркадии добавить файлы с этим расширением, CUDA будет автоматически использована для их сборки.

В аркадийной сборке зафиксированы некоторые версии CUDA для некоторых платформ. Также существует возможность использовать свой CUDA Toolkit.

## HAVE_CUDA
Чтобы в ya.make узнать, доступна ли CUDA для текущей сборки, можно проверять переменную `HAVE_CUDA`.
Установив эту переменную в `no`, можно принудительно отключить сборку кода для CUDA, даже если она доступна в Аркадии.
Если был указан пользовательский CUDA Toolkit, `HAVE_CUDA` устанавливается в `yes`.
### Пример

ya.make: 
``` 
IF (HAVE_CUDA)
    SRCS(kernel.cu)
ENDIF()
```
Команда сборки: `ya make -DHAVE_CUDA=no`

## CUDA_VERSION
Версию аркадийной CUDA можно указать через переменную `CUDA_VERSION`. Сейчас доступны версии `10.1` (по умолчанию) и `11.3`.
### Пример
`ya make -DCUDA_VERSION=11.3`

## CUDA_HOST_COMPILER
Вместе с аркадийной CUDA фиксируется также совместимая версия host compiler. Можно использовать свой, указав его в переменной `CUDA_HOST_COMPILER`.

Если используется внешний CUDA Toolkit, и `CUDA_HOST_COMPILER` не указан, то автоматически выбирается соответствующий из Аркадии. Если нужно, чтобы внешний CUDA Toolkit самостоятельно попытался использовать системный компилятор, следует указать пустое значение «`-DCUDA_HOST_COMPILER=`».

### Пример
`ya make -DCUDA_HOST_COMPILER=/usr/bin/gcc-6.1`

## CUDA_USE_CLANG
Если установлена, использовать Clang как компилятор CUDA.
*Экспериментальная опция*
### Пример
`ya make -DCUDA_USE_CLANG`

## CUDA_NVCC_FLAGS
Дополнительные опции, которые будут переданы `nvcc` при компиляции любого `*.cu`-файла.
### Пример
`ya make -DCUDA_NVCC_FLAGS=--use_fast_math`

## CUDA_ROOT
Можно указать свой CUDA Toolkit, через переменную `CUDA_ROOT`.
Вместе со своим CUDA Toolkit можно дополнительно использовать настройки `CUDA_HOST_COMPILER` и `CUDA_NVCC_FLAGS`.
### Пример
`ya make -DCUDA_ROOT=/usr/local/cuda-9.1`
