### Flaky тесты

Тест должен быть стабильным и зависеть только от ревизии (состояние репозитория). Если результат теста или его имя меняется при перезапусках - это плохой тест и он будет всем мешать. Мы стараемся такие тесты подавлять и размечаем их статусом `FLAKY`, который не меняет статус `review`-проверки на красный (поломка).
`Flaky` тесты могут возникать по ряду причин:
- недетерминированное имя теста. Обычно это происходит если в параметризации используется:
  - рандом
  - контейнер без гарантий на порядок обхода элементов `dict, map, etc`
  - адреса объектов в памяти
  - время
  - абсолютные пути
  - любая недетерминированная функция или функция, результат которой не зависит только состояния репозитория
- недетерминированное поведение самого теста, ввиду
  - нестабильной работы библиотеки/тестов (плавающие трассы выполнения, проверка вероятностных инвариантов)
  - использования внешних сервисов в тестировании.
  - предположения, что тест запускается в определенной таймзоне без явной декларации таймзоны.

Мигание тестов можно воспроизводить локально запуская `ya make -tA --tests-retries N`, где `N`- количество перезапусков больше 1.
