# ya ide idea : генерация проекта для JetBrains IntelliJ Idea

&nbsp;
[IntelliJ IDEA](https://www.jetbrains.com/ru-ru/idea/) от компании JetBrains является стандартом де-факто для java-разработчика в Яндексе. Хэндлер **ya ide idea** генерирует проект для данной ide по Аркадийному описанию сборки.

**Поддерживаются следующие флаги:**
- `-r={path}, -P {path}, --project-root={path}` указать корень того места, куда будут сгенерированы файлы описания проекта (директория .idea) и артефакты зависимостей (.jar и -sources.jar java-контрибов, .so для jni). Единственный обязательный флаг. Рекомендуется указывать путь за пределами vcs root.
- `-l, --local` экспортировать `PEERDIR`-зависимости модулей как артефакты. В этом случае исходники и тесты размечаются только для целевых модулей. Зависимости собираются один раз и кладутся в проект артефактами аналогично контрибам. Это позволяет ускорить работу собственной системы сборки idea (так как она собирает меньшее количество кода).
- `--group-modules=(tree, flat)` группировка модулей в интерфейсе idea:
  - flat (по умолчанию) - плоский список модулей
  - tree - группировка по путям в Аркадии
- `--iml-in-project-root` сохранять файлы описания модулей (.iml) в `--project-root`. По умолчанию эти файлы сохраняются рядом с ya.make своих модулей. В ближайшее время мы планируем сделать такое поведение дефолтом, в этом случае появится обратный флаг _--iml-in-source-root_.
- `--iml-keep-relative-paths` генерировать в .iml файлах относительные пути (по умолчанию абсолютные). Позволяет копировать проект с машины на машину. Данный флаг можно укзать только совместно с `--iml-in-project-root`.
- `--omit-test-data` не экспоритровать тестовые данные, описанные макросом `DATA` в idea проект. В случае, если у теста объемная data (как по размеру, так и по количеству файлов), может значительно ускорить работу `ya ide idea`.
- `--with-content-root-modules` сгенрировать фейковый модуль с content root, указывающим на папку целевого Аркадийного проекта. Позволяет отображать в интерфейсе всю файловую структуру проекта (даже то, что в idea не экспортируется).
- `--directory-based` создать проект в более новом формате (вместо одного .ipr файла создается директория .idea с набором файлов). Данный формат позволяет, например, расшаривать run-конфигруации между различными проектами. **Включена по умолчанию**
- `--generate-tests-for-dependencies` дополнительно сгененрировать тесты (где это возможно) для зависимостей стартотвых проектов (т.е. для модулей, которые доступны им по `PEERDIR`).
- `--separate-tests-modules` создать для тестов отдельные модули (вместо вместо разметки test srcs в "библиотечном" модуле). Флаг может быть полезен в ситуации, когда одной библиотеке соответсвует несколько тестовых модулей (т.к. они могут иметь конфликтующий classpath).
- `--external-content-root-module=/path/to/directory` - добавить кастомный синтетический *content root module*. Можно указать относительный путь, в этом случае он будет расчитан от текущего cwd. Флаг можно указать несколько раз (для генерации нескольких модулей). Созданный модуль по характеристикам аналогичен `--with-content-root-module` (кроме пути, на который он смотрит).
- `--exclude-dirs=relative/path/to/directory` - добавить в каждый сгенерированный модуль exclude-директорию. Флаг можно указать несколько раз (для множественных exclude). Он может быть полезен для ускорения индексации проекта идеей.
- `--auto-exclude-symlinks` - найти симлинки под каждым модулем и сделать на них `--exclude-dirs`. С данным флажком в exclude автоматом попадет, например, папка test-results.
- `--with-common-jvm-args-in-junit-template` - добавить аргументы в дефолтный run template. Список аргументов формируется как пересечение всех непустых JVM_ARGS тестовых модулей проекта. Флаг позволяет запускать тесты из GUI Idea по кнопке сразу с проставленными JVM параметрами. Указывать его имеет смысл, только если в вашем проекте тестовые модули не содержат конфликтующие наборы JVM_ARGS (непустое пересечение). В противном случае вы по-прежнему можете использовать шаблонные конфигурации ( --generate-junit-run-configurations ).

**Флаг, используемый только совместно с *directory-based* проектами:**
- `--generate-junit-run-configurations` сгенерировать шаблоны запуска junit-тестов для модулей.

**Флаги, используемые только совместно с *file-based* проектами:**
- `--project-name={value}` указать имя .ipr файла.
- `--ascetic` минимизирует структуру создаваемого .ipr файла.

{% note tip %}

**Java-комитет** рекомендует использовать следующий набор флагов:
```
ya ide idea --group-modules tree --omit-test-data --iml-in-project-root --local -r ~/IdeaProjects/<project_name>
```

{% endnote %}

При использовании [IntelliJ devtools plugin](https://a.yandex-team.ru/arc/trunk/arcadia/devtools/intellij/README.md) поддерживается перегенерация проекта из интерфейса IDE. Проект в этом случае будет создан с тем-же набором флагов, что были первоначально переданы в CLI.
