# Сборка deb-пакетов

Сборка debian-пакета производится с помощью команда
```bash
ya package --debian <package.json>
```

## Ключи для сборки deb-пакетов { #keys }
* `--not-sign-debian` не подписывать пакет: такой пакет не удасться загрузить в репозиторий, но для отладки в локальных запусках подходит
* `--debian-distribution` указание `Debian distribution` при сборке пакета (по умолчанию: `unstable`)
* `--debian-arch` указание архитектуры (передается команде ```debuild``` через ключ ```-a```)
* `--arch-all` синоним `Architecture: all`
* `--force-dupload` форсированная загрузка (```dupload --force```)
* `--debian-compression, -z` степень сжатия deb-файла (`none`, `low`, `medium`, `high`)
* `--debian-compression-type, -Z` тип сжатия deb-файла (`gzip`, `xz`, `bzip2`, `lzma`, `none`)
* `--publish-to` публикация пакета в репозитории (под капотом происходит вызов команды `dupload`)
* `--dupload-max-attempts` количество попыток публикации пакета при вызове команды ```dupload``` (по умолчанию 1)
* `--dupload-no-mail` указание вызывать команду ```dupload``` с ключом ```--no-mail```
* `--ensure-package-published` дожидаться публикации пакета в репозитории

## Работа с конфигурационными файлами { #conffiles }
В ```ya package``` по историческим причинам по умолчанию включен хелпер `dh_noconffiles`, при котором никакие файлы не считаются файлами конфигурации (в т.ч. из папки `/etc`), для отмены данного поведения надо использовать ```"noconffiles_all": false``` в секции [meta](json.md#meta)`([пример](https://a.yandex-team.ru/arc/trunk/arcadia/devtools/ya/package/tests/fat/data/package_conffiles.json?rev=4258754#L7))

## Вызов дополнительных хелперов { #debhelpers }
Если надо вызывать дополнильные хелперы, можно воспользоваться файлом `debian/extra_rules` ([примеры в репозитории](https://cs.yandex-team.ru/#!,extra_rules,,arcadia)).

## postinst, prerm etc { #debian }
В случае, если требуются `postinst` и иные стандартные debian-файлы, нужно создать каталог `debian` рядом с json-описанием пакета, в котором поместить нужные файлы, например, `postinst`.
*ВАЖНО* в файлах postinst, prerm и других должна быть строка `#DEBHELPER#`

## Сборка deb-пакетов для Python { #deb-python }
При наличии в пакете путей, в которые устанавливаются пакеты для python, например, `/usr/lib/python2.7/dist-packages`, срабатывает debian-хелпер `dh_pysupport`, включенный по умолчанию, который все файлы в таких путях перекладывает в «правильные» по его мнению места, а именно в `usr/share/pyshared`. В связи с этим:
1. Не будет работать смена владельцев и изменения прав на файлы, так как данное действие происходит после вызова этого хелпера и исходных путей нет.
2. Нужно не забыть добавить в файл-описание пакета в секцию meta, в список `pre-depends` добавить зависимость от пакета `python-support` иначе на чистой машине пакет не подключится к Python несмотря на наличие файлов.

Для того, что отключить `dh_pysupport`, нужно рядом с файлом описания пакета положить файл `debian/extra_rules` с таким содержимым:

```
override_dh_pysupport:
    # Nothing to do
```

Если сборка пакета явно закладывается на `dh_pysupport`, то необходимо добавить в секцию `build-depends` пакет `python-support`:
```json
 "meta": {
        ...
        "build-depends": ["python-support"]
    },
```

## Воспроизводимость сборки и совместимость между дистрибутивами { #ubuntu-version }
```ya package``` использует системные инструменты для сборки deb-пакетов, поэтому результат зависит от используемой ОС и может быть не совместим с другой.
* алгоритм компрессии (xz) выбираемый `dpkg-builddeb` по умолчанию в новых версиях Ubuntu не совместим c precise
* на дистрибутивах до xenial не получится правильно собрать пакет с поддержкой systemd

## Особенности запуска через задачу YA_PACKAGE { #sandbox }
Для публикации пакетов в dist.yandex-team.ru из задачи Sandbox следует выбрать робота в поле задачи `key_user`, чтобы подписывать и загружать пакеты от его имени.

Если необходимо создать нового робота для подписи, нужно сделать следующее:

1. [Заводим робота](https://wiki.yandex-team.ru/tools/support/zombik) с почтовым ящиком и запрашиваем права на заливку пакетов через в [Управляторе](https://idm.yandex-team.ru) в системе `Cauth->conductor.dist-duploaders->SSH`
    По умолчанию у робота  командный процессор выставлен в ```/bin/false```, поэтому нужно зайти в аккаунт робота на Стаффе, кликнуть на аватарку в шапке, перейти в «Настройки», и поменять «Командный процессор», например, на ```/bin/bash```, чтобы робота не вкидывало с серверов при авторизации по ssh.

2. Генерируем для робота пару SSH-ключей (допустим, робота зовут `robot-bender`):
    ```bash
     ssh-keygen -t rsa -b 2048 -m PEM -C robot-bender@yandex-team.ru -f robot-bender-ssh
   ```
   Парольную фразу (passphrase) оставляем пустой. Содержимое robot-bender-ssh.pub (публичный ключ) кладём на Cтафф, залогинившись роботом.

3. Содержимое файла robot-bender-ssh (приватный ключ) кладём в зашифрованное хранилище [Sandbox Vault](https://sandbox.yandex-team.ru/admin/vault). Владельцем (Owner) записи в Vault выставляем [группу в Sandbox](https://sandbox.yandex-team.ru/admin/groups), от которой выполняются задачи (допустим, она называется `IEX-CI`). Имя записи = имя робота + '-ssh', `robot-bender-ssh`. Содержимое (data) — копи-пейст ключа.

4. Создаем GPG-ключи
    1. Генерируем ключи:
    ```bash
    gpg --gen-key
    ```
    Отвечаем, что ключ нужен для Робота Бендера, указываем его почтовый адрес `robot-bender@yandex-team.ru`. *Важно*, чтобы в качестве почтового адреса был указан адрес робота.

    2. Получаем права на upload в репозиторий. Экспортируем ключ:
    ```bash
    gpg --export --armor robot-bender >robot-bender.gpg
    ```
    (Обратите внимание на *наличие* опции ```--armor```)
    Добавляем ключ на Стафф.

    3. Экспортируем ключи для зашифрованного хранилища Sandbox Vault:
    ```bash
    gpg --export robot-bender | base64
    ```
    (Обратите внимание на *отсутствие* опции ```--armor```)
    ```bash
    gpg --export-secret-keys robot-bender | base64
    ```
    (у ключа не должно быть пароля, а то ключ нельзя будет использовать внутри sandbox)

    Получившееся [кладём в Vault]((https://sandbox.yandex-team.ru/admin/vault)) под именами `robot-bender-gpg-public` и `robot-bender-gpg-private` соответственно. Владелец записей по-прежнему (как и пункте 2) - группа `IEX-CI`.

    [Подробнее про GPG-ключи написано в документации к dist](https://doc.yandex-team.ru/Debian/deb-pckg-guide/concepts/GPG.xml)

5. Добавить робота и его группу в [список роботов задачи](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/common/build/ya_package_config/consts.py?rev=r7844539#L503) (после коммита надо подождать около 30 минут, пока код задач обновится на сервере).

