# Метод generate {#generate}

Возвращает ключ капчи и ссылку на изображение. 

## Синтаксис запроса {#request}
```
http://api.captcha.yandex.net/generate
  ? [type=<std|lite|rus>]
  & [checks=<1-9>]
  & [https=<on|any>]
```

#|
|| **Параметр** | **Значение** ||
|| type |  Тип капчи:
 - std — обычная.
 - lite — упрощенная.
 - rus — из букв русского алфавита.

При отсутствии аргумента подразумевается `type=std`.

Рекомендуется явно указывать тип капчи, поскольку тип по умолчанию зависит от настроек капча-сервера и может быть изменен. ||

|| checks | Количество проверок, которые должен обеспечить капча-сервер (от 1 до 9). Если аргумент не указан, капча-сервер допускает только одну проверку. ||

|| https | Протокол для ссылки на изображение капчи
 -  on — будет сгенерирована HTTPS-ссылка.
 -  any — ссылка будет возвращена без схемы: `//u.captcha.yandex.net/image?key=...`. ||
|#

> ## Пример 1
> 
> Запрос обычной капчи с возможностью проверить ответ пользователя два раза.
> `http://api.captcha.yandex.net/generate?type=std&checks=2`

> ## Пример 2
> 
> Запрос упрощенной капчи с возможностью проверить ответ пользователя один раз.
> `http://api.captcha.yandex.net/generate?type=lite`

## Формат ответа {#answer}

Ответом является XML-структура следующего вида.

```xml
<?xml version='1.0'?>
<number url="URL-WITH-KEY">KEY</number>
```

 **Элемент** | **Значение** 
 --- | --- 
 number | Элемент содержит ключ капчи. Сервис должен запомнить ключ и впоследствии вернуть его на капча-сервер вместе с ответом пользователя (см. метод [check](check.md)).
 url | Атрибут содержит ссылку в формате запроса HTTP GET. Данную ссылку сервис без изменений размещает на HTML-странице, которая отдается пользователю. Браузер получает по данной ссылке изображение напрямую с капча-сервера.

Ниже приведен пример ответа.

```xml
<?xml version='1.0'?>
<number url="http://u.captcha.yandex.net/image?key=10pIGk1YA_uMYERwCg9Zzltn_cQ3bBOF">10pIGk1YA_uMYERwCg9Zzltn_cQ3bBOF</number>
```

## Сообщения об ошибках {#id017E98EC}

Метод возвращает сообщения о стандартных HTTP-ошибках:

- 403 — отсутствуют полномочия на доступ;
- 500 — ошибка в работе капча-сервера, причина ошибки не уточняется;
- 502 — капча-сервер не обработал запрос (не запущен или высокая нагрузка).