# Описание капча-сервера

В разделе приведены общие сведения о технической архитектуре и функциях капча-сервера, описан алгоритм проведения теста на распознавание символов.

Капча-сервер — это аппаратно-программный комплекс, обеспечивающий проведение теста на распознавание символов. Выполняет следующие задачи:

- генерирует искаженные и зашумленные изображения символов и уникальные идентификаторы (ключи) для этих изображений;
- выдает ключи и ссылки на изображения;
- выдает изображения по ссылкам;
- проверяет ответы пользователей.

Программные модули капча-сервера написаны на языке Perl.

Капча-сервер имеет территориально распределенную структуру. Независимые экземпляры капча-сервера расположены в нескольких дата-центрах. Запросы на адрес `http://api.captcha.yandex.net` передаются в наименее загруженный дата-центр, благодаря чему осуществляется балансировка нагрузки. При недоступности одного из дата-центров запросы передаются в работоспособный дата-центр.

## Термины и определения {#terms}

В настоящем документе применяются следующие термины с соответствующими определениями.

#### Капча

Под капчей понимается автоматический тест на различение компьютеров и людей. Основная идея теста — предложить пользователю задачу, решаемую человеком, но нерешаемую компьютером за ограниченное время. В основном такие задачи относятся к распознаванию символов.

Слово «капча» является транслитерацией английского акронима CAPTCHA — Completely Automatic Public Turing Test to Tell Computers and Humans Apart (полностью автоматический тест Тьюринга для различения компьютеров и людей).

#### Изображение капчи

Изображение последовательности цифр или букв, сгенерированное капча-сервером. Имеет формат GIF, размер 200х60 px, глубину цвета 8 бит.

Для генерации используются функции библиотеки [ImageMagic](http://www.imagemagick.org). Символы искажаются и зашумляются путем наложения графических эффектов, зависящих от псевдослучайной функции. Благодаря этому искажение и зашумление в каждом изображении отличается от других изображений, что препятствует автоматическому декодированию.

#### Ключ капчи

Уникальный идентификатор изображения капчи. Ключ выдается сервису в начале теста, а затем возвращается на капча-сервер вместе с ответом пользователя. Пример ключа: `10pIGk1YA_uMYERwCg9Zzltn_cQ3bBOF`

#### Ответ пользователя
Строка, введенная пользователем в качестве ответа на задачу распознавания символов. Сервис получает ответ пользователя и передает на капча-сервер вместе с выданным ранее ключом.
#### Тайм-аут теста
Максимальная продолжительность времени, в течение которого капча-сервер ожидает получить ответ пользователя для проверки. Составляет 60 минут от момента, когда сервис инициировал тестирование.

