# Утилита ya

{% note info %}

Процедура установки утилиты `ya` описана в разделе [Быстрый старт](../intro/quick-start-guide.md).

{% endnote %}

Основным инструментом, используемым для сборки и тестирования исходных кодов, является утилита `ya`. Чтобы получить полный список поддерживаемых команд:

```bash
$ ya --help
```

Утилита имеет несколько назначений:

1. **Сборка исходного кода.** Для этого используется команда `ya make` с различными флагами.
2. **Запуск разнообразных инструментов разработки.** Основная часть таких инструментов вызывается командой `ya tool`.

## Сборка исходного кода { #ya-make }

Здесь приведены наиболее простые и часто используемые команды для сборки исходного кода, которые могут понадобиться вам в повседневной работе.

* **Посмотреть справочную информацию про сборку исходного кода:**

    ```bash
    $ ya make --help
    ```

* **Собрать исходный код в текущем каталоге:**

    ```bash
    $ ya make
    ```
    Команда будет работать в независимости от того на каком языке программирования написан код. По-умолчанию **результаты сборки** (например, скомпилированный исполняемый файл) складываются в текущий каталог.

* **Собрать исходный код в произвольном каталоге единого репозитория:**

    ```bash
    $ ya make my-project/my-app
    ```
    Можно перечислять несколько таких каталогов (**целей**) одновременно:
    ```bash
    $ ya make my-project/my-app ~/arcadia/another-project/another-app
    ```
    Пути до каталогов могут быть абсолютными и относительными. Относительные пути вычисляются относительно текущего каталога. Результаты сборки также будут находиться в каждом из указанных каталогов по-отдельности.

* **Сложить результаты сборки в указанный каталог:**

    ```bash
    $ ya make -o /path/to/output/dir
    $ ya make -o /path/to/output/dir my-project/my-app
    ```

* **Собрать и протестировать:**

    ```bash
    $ ya make -t
    ```
    Подробности о том, как использовать `ya make` для запуска тестов, описаны в следующей части данной документации.

* **Включить подробный (verbose) вывод о ходе сборки:**

    ```bash
    $ ya make -v
    ```

    {% note info %}

    Команды `ya -v make` и `ya make -v` имеют разный эффект. Первая команда добавляет вывод утилиты `ya`, вторая — вывод процесса сборки.

    {% endnote %}

* **Очистить кеш сборки:**

    В ходе работы команда `ya make` складывает зависимости в каталог `~/.ya/build`. Со временем размер этого каталога может сильно расти. Для того, чтобы очистить эти временные файлы:

    ```bash
    $ ya gc cache
    ```

## Отладка с помощью gdb { #ya-gdb }

На данный момент есть несколько способов отладки с помощью [gdb](https://www.gnu.org/software/gdb/) внути ya:
* **Запуск наиболее свежего gdb, работающего под ОС хоста:**
```bash
$ ya gdb
```
* **Запуск фиксированной версии gdb:**
```bash
$ ya tool gdb
```
* **Запуск тестов с последующим запуском gdb в случае аварийного завершения:**
```
ya make -t --gdb
```

Полезный пост в Этушке ["Про отладку, или как я перестал беспокоиться и полюбил GDB"](https://abv.at.yandex-team.ru/583).

## Запуск инструментов разработки { #devtools }

Полный список доступных инструментов можно посмотреть так:

```bash
$ ya tool --help
```

Примеры того, что вы можете сделать при помощи `ya tool` приведены ниже.

* **Управление контейнерами в [Yandex.Deploy](https://yd.yandex-team.ru/):**

    ```bash
    $ ya tool dctl list project # Вывести список доступных проектов
    $ ya tool dctl list stage # Вывести список доступных окружений
    ```

* **Управление виртуальными машинами в [QYP](https://qyp.yandex-team.ru/):**

    ```bash
    $ ya tool qyp list # Вывести список виртуальных машин
    $ ya tool qyp shutdown --pod-id my-vm-name --cluster SAS # Остановить виртуальную машину
    ```

* **Доступ к JSON процессору [jq](https://stedolan.github.io/jq/):**

    ```bash
    $ ya tool jq --help # Справочная информация по конкретному инструменту
    $ echo -n '{"foo": 42, "bar": "less interesting data"}' | ya tool jq '.foo'
    42
    ```

Список инструментов достаточно длинный и содержит, в том числе, компиляторы разных языков программирования, консольные клиенты для различных сервисов Яндекса, инструменты для низкоуровневой отладки и трассировки работающих приложений ([strace](https://en.wikipedia.org/wiki/Strace), [gdb](https://www.gnu.org/software/gdb/), [Valgrind](https://valgrind.org/)) и так далее.
