# Рекомендации по написанию документации

Для документирования используется платформа [Docs](https://docs.yandex-team.ru/). Всю новую документацию рекомендуется писать только на этой платформе. Старая документация должна быть перенесена на платформу [Docs](https://docs.yandex-team.ru/). При переносе необходимо ставить ссылки на новую документацию из старой документации (например, со страницы на [Wiki](https://wiki.yandex-team.ru/)).

Различают два типа документации:

1. **Проектная документация** описывает в больших подробностях все, что связано с одним конкретным проектом или инструментом. Например, [документация YT](https://yt.yandex-team.ru/docs/) или [документация Sandbox](https://docs.yandex-team.ru/sandbox/) - это проектная документация.

2. **Руководство** (**handbook**) - описывает способы решения проблем пользователя с помощью одного или нескольких инструментов. Например, данная документация — это руководство по разработке в едином репозитории.

## Хранение документации { #storage }

1. По соглашению исходные коды **проектной документации** проекта `my-project` должны лежать в каталоге `/my-project/docs`. Например, документация YT лежит в [/yt/docs](https://a.yandex-team.ru/arc/trunk/arcadia/yt/docs), а документация Sandbox - в [/sandbox/docs](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/docs).
2. Для исходных кодов **руководства** нет соглашения о хранении исходных кодов. Пока такие проекты складываются в [/docs](https://a.yandex-team.ru/arc/trunk/arcadia/docs).
3. Сервис [Docs](https://docs.yandex-team.ru/) отвечает за хранение документации. При этом его главная страница генерируется автоматически и не очень удобна для использования живыми пользователями. В качестве замены ссылку на документацию вашего сервиса можно добавить в специальный каталог [Yandex Infrastructure](https://i.yandex-team.ru), ссылку на который присылают в письме всем новым разработчикам Яндекса.

## Изменение документации { #update }
1. По возможности документация для новой функциональности, которую видят пользователи, должна добавляться в **одном пулл-реквесте с кодом и тестами**.
2. При внесении изменений в функциональность, которую видят пользователи, также следует обновлять документацию в **одном пулл-реквесте с изменившимся кодом**.
3. При разработке **экспериментальных возможностей**, поведение которых может меняться в будущем, документация должна делаться в момент, когда поведение стабилизируется. При этом на документирование таких возможностей может заводится отдельная задача и делаться отдельный пулл-реквест. Если есть опасения, что возможность будет долго оставаться экспериментальной, можно сделать специальный раздел с экспериментальными возможностями и положить документацию туда.

