# Авторизация и роли

Для работы с сервисами разработческой инфраструктуры, будь то репозиторий Аркадии, Sandbox или какая-либо другая сущность – необходимы не только сетевые доступы, но и авторизация на уровне самого сервиса, это касается как сотрудников, так и роботов с зомбиками. В зависимости от сервиса, доступны различные способы аутентификации и авторизации, а также различные модели управления ролями – тем, кто и к чему имеет доступ.

## Репозиторий Аркадии {#repo}

Сотрудникам Яндекса как правило не нужно предпринимать никаких специальных действий для того, чтобы начать работать с Аркадией, помимо тех, которые описаны в [быстром старте](quick-start-guide.md), так как доступ до Аркадии сейчас есть у всех штатных сотрудников по умолчанию.

Для допуска к репозиторию роботов понадобится явным образом заказать роль через IDM: [Arc → Arcadia → Access → Robot](https://idm.yandex-team.ru/system/arc/roles#rf=1,rf-role=qFNAwvfR#arc/arcadia/access/robot(fields:()),f-status=all,f-role=arc,sort-by=-updated,rf-expanded=qFNAwvfR). Данная роль позволяет роботу свободно работать с Arc и Arcanum практически любым способом: роботу не будет доступна только расширенная функциональность по одобрению пулл-реквестов и изменению настроек их вливания в сторону ослабления (например, робот не сможет нажать Ship в пулл-реквесте, где затребовано ревью кода).

Роботам, которые нуждаются в расширенной функциональности по работе с пулл-реквестами, необходимо выдать дополнительную роль [Arcanum → Developer](https://idm.yandex-team.ru/system/arcanum/roles#rf=1,rf-role=wHOdqI26#arcanum/ROLE_DEVELOPER(fields:()),f-status=all,f-role=arcanum,sort-by=-updated,rf-expanded=wHOdqI26). Для работы с SVN-репозиторием или для работы с `full` репозиторием Arc (read-only зеркалом SVN-репозитория) потребуется роль [Arc → Svn (full) → Access → Robot](https://idm.yandex-team.ru/system/arc/roles#rf=1,rf-role=qFNAwvfR#arc/full/access/robot(fields:()),f-status=all,f-role=arc,sort-by=-updated,rf-expanded=qFNAwvfR).

{% note info "Монтирование Аркадии в Sandbox" %}

Использование Аркадии в Sandbox – частный случай роботного доступа к репозиторию, поэтому роль робота необходима. Arc SDK в SB использует URLы специального вида для указания подключаемого репозитория и способа подключения. В зависимости от типа URL могут потребоваться различные роботные роли:

* `arcadia-arc:/#<commit-or-branch>`: обычное монтирование Аркадии через Arc, для использования понадобится стандартная роль робота `Arc → Arcadia → Access → Robot`
* `arcadia:/arc/<svn-path>[@<revision>]`: монтирование SVN-репозитория Аркадии через Arc, либо прямой доступ к SVN-репозиторию (в зависимости от параметров), для использования понадобится специальная роль робота с доступом к SVN `Arc → Svn (full) → Access → Robot`

{% endnote %}

Для внешних сотрудников роли в IDM заказываются после создания outstaff-проекта. Подробнее про это можно почитать в [соответствующем разделе документации](../src/outstaff.md).

### Способы взаимодействия {#repo-interface}

С репозиторием Аркадии и пользователи, и сервисы взаимодействуют различными способами:
* Веб-интерфейс [Arcanum](https://a.yandex-team.ru) узнает пользователя через [паспортный](https://passport.yandex-team.ru) логин
* Система контроля версий `arc` использует для аутентификации [OAuth](https://wiki.yandex-team.ru/oauth)
* Сервисы ходят в [Arc API](https://a.yandex-team.ru/arc_vcs/arc/api/public) и [Arcanum API](https://a.yandex-team.ru/api/swagger), используя как [OAuth](https://wiki.yandex-team.ru/oauth), так и [TVM](https://wiki.yandex-team.ru/passport/tvm2)
* При использовании SVN применяются ключи [SSH](https://wiki.yandex-team.ru/security/ssh)
* Различные другие приложения, с которыми работает пользователь, такие как утилита `ya` или плагины к IDE, также могут использовать [OAuth](https://wiki.yandex-team.ru/oauth) для работы с Arc или Arcanum

### OAuth {#repo-oauth}

OAuth – стандартный способ аутентификации, если речь не идет о межсервисном взаимодействии, хотя для межсервисного взаимодействия OAuth-токены тоже регулярно применяются (в этом случае токен выписывается на робота).

При использовании OAuth на стороне сервера проверяются скоупы токенов:
* Arc: `arc:read` и `arc:write`
* Arcanum: `arcanum:api_read`

Какие OAuth-токены обычно используются для работы с репозиторием со стороны пользователя (или робота, если робот пользуется CLI-утилитами вместо API):
Приложение | Сервисы | OAuth-приложение | Ссылка для получения токена
:--- | :--- | :--- | :---
Утилита `arc` | Arc, Arcanum | [Arc VCS client](https://oauth.yandex-team.ru/client/5c407aafc5c242948b532842a9a07da6) | [click](https://oauth.yandex-team.ru/authorize?response_type=token&client_id=5c407aafc5c242948b532842a9a07da6)
Утилита `ya` | Arc, Arcanum, ... | [Ya](https://oauth.yandex-team.ru/client/f4d36b7671004ed9850148fa645acac6) | [click](https://oauth.yandex-team.ru/authorize?response_type=token&client_id=f4d36b7671004ed9850148fa645acac6)

Сервисы могут работать с Аркадией по API:
Сервисы | OAuth-приложение | Ссылка для получения токена
:--- | :--- | :---
Arc API, Arcanum API | [Arcanum & Arc API](https://oauth.yandex-team.ru/client/38516279b97647ae9a5143dd3798d0cd) | [click](https://oauth.yandex-team.ru/authorize?response_type=token&client_id=38516279b97647ae9a5143dd3798d0cd)

Все перечисленные выше токены на самом деле взаимозаменяемы в смысле возможностей, которые они предоставляют при работе с Аркадией.

### Роли {#repo-roles}

Для управления ролями в репозитории используется [IDM](https://wiki.yandex-team.ru/intranet/idm)-система [Arc](https://idm.yandex-team.ru/system/arc).

Используется следующая иерархия "узлов ролей":
* `Arc`
    * `Arcadia`: стандартный доступ к репозиторию Аркадии
        * `Access`: полный доступ к репозиторным данным
            * `User`: штатный сотрудник (роль по умолчанию выдана на всех сотрудников Яндекса)
            * `Robot`: робот или зомбик
        * `Partial access`: доступ к репозиторным данным, ограниченный по путям
            * Outstaff-проект: ограниченный доступ предоставляется на основе outstaff-проектов, определяющих наборы путей
                * `External user`: внешний сотрудник
    * `Svn (full)`: доступ к SVN-репозиторию Аркадии или read-only доступ к его зеркалу в Arc (так называемый `full` репозиторий)
        * `Access`: основные роли доступа к репозиторным данным
            * `User`: штатный сотрудник (роль по умолчанию выдана на всех сотрудников Яндекса)
            * `Robot`: робот или зомбик

Явного заказа обычно требуют только роли для роботов и внешних сотрудников.

Система Arc является основной точкой входа, роли в других системах и [сетевые доступы](firewall.md) зависят от ролей, выданных в ней:
* Выдача любой роли в системе гарантирует сетевой доступ до Arc VCS.
* Выдача ролей в Аркадии (`Arc → Arcadia`) автоматически выдает необходимые роли и сетевой доступ к Arcanum.
* Выдача ролей с полным доступом к Аркадии (`Arc → Arcadia → Access`) обеспечивает сетевую доступность таких смежных сервисов, как аркадийный поиск по коду.
* Выдача ролей для доступа к SVN (`Arc → Svn (full)`) гарантирует как доступ к `full` репозиторию (зеркалу SVN-репозитория в Arc), так и к собственно SVN-репозиторию по SSH.
